# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A (as Player A)
# Meta-Round: 4
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_A_MR4_strategy.txt
# LLM Suggested Fallback: D

def harmony_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Track opponent's cooperation rate for adaptive response
    trust_score = sum(1 for move in opp_history if move == "C") if opp_history else 0
    current_round = len(my_history) + 1
    
    # Initial trust-building phase (Rounds 1-3)
    if current_round <= 3:
        return "C"
    
    # Pattern disruption phase (Rounds 4-7)
    if 4 <= current_round <= 7:
        if current_round == 4 or current_round == 6:
            return "D"
        else:
            return "C"
    
    # Late-game exploitation (Rounds 8-10)
    if current_round >= 8:
        if trust_score >= 5:
            return "D"
        else:
            return "C" if current_round % 2 == 0 else "D"
    
    # Fallback (should never reach here)
    return "C"